
/******************** (C) COPYRIGHT 2003-2004 STMicroelectronics ***************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 12/10/2005
* Description        : STR73x Low Power Modes for the STR73x Power
*                      Management AN2202
********************************************************************************
* History:
*  08/08/2006 : V2.0
*  12/10/2005 : V1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "73x_lib.h"

/* Private typedef -----------------------------------------------------------*/

/* Slow clock typedef */
typedef enum
{
  CLK2,
  CLK2_16,
  FREE_PLL,
  CLK
} SlowClock_Typedef;

/* Private define ------------------------------------------------------------*/

#define  WIU_STOP_Bit  0x04
#define  WUTPrescaler  0xFFF
#define  WUTPreload    0xFFFF

/*IP structure declaration*/
PRCCU_InitTypeDef  PRCCU_InitStructure;
CMU_InitTypeDef    CMU_InitStructure;
RTC_InitTypeDef    RTC_InitStructure;
ADC_InitTypeDef    ADC_InitStructure;
TIM_InitTypeDef    TIM_InitStructure;
WUT_InitTypeDef    WUT_InitStructure;
WIU_InitTypeDef    WIU_InitStructure;
GPIO_InitTypeDef   GPIO_InitStructure;

/* Private function prototypes -----------------------------------------------*/
void Enter_LPmode (void);
void EIC_Configuration(void);
void WIU_Configuration(void);
void ADC_Configuration(void);
void GPIO_Configuration(void);
void GPIO_PinToggle(void);
void Delay(u32 Delay);

/* -------------------- Low power mode entering function -------------------- */

/* #define SLOW_Mode */

/* #define SLOW_RC_Mode */

/* #define WFI_Mode */

/* #define LPWFI_Mode */

/* #define LPWFI_RC_Mode */

/* #define HALT_Mode */

#define STOP_Mode

/* #define STOP_WUT_Mode */

/* #define RUN_Mode */
/* uncomment to use the ADC in the Test_RUN routine */
/* #define ADC_ON */


/* #define RUN_ALLON_Mode */
/*uncomment to measure the consumption when RTC and GPIO4 are used */
/* #define RTC_Mode */


/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

int main(void)
{
  u32 counter = 10;
#ifdef DEBUG
  debug();
#endif

  /* Set system, peripheral clocks */
  CMU_StructInit(&CMU_InitStructure);
  CMU_InitStructure.CMU_CKSEL0=CMU_CKSEL0_CKOSC;
  CMU_Init (&CMU_InitStructure);

  PRCCU_StructInit(&PRCCU_InitStructure);
  PRCCU_InitStructure.PRCCU_DIV2=ENABLE;
  PRCCU_InitStructure.PRCCU_MCLKSRC_SRC=PRCCU_MCLKSRC_PLL;
  PRCCU_InitStructure.PRCCU_PLLDIV=PRCCU_PLLDIV_2;
  PRCCU_InitStructure.PRCCU_PLLMUL=PRCCU_PLLMUL_12;
  PRCCU_Init(&PRCCU_InitStructure);

  /* peripheral clock configuration */
  /* CFG_PeripheralClockConfig (CFG_CLK_RAM, ENABLE); */
  CFG_PeripheralClockConfig (CFG_CLK_WIU, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_EIC, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO0, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO1, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO2, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO3, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO4, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO5, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_GPIO6, ENABLE);

  /* GPIO configuration & initialization*/
  GPIO_WordWrite (GPIO0,0x0);
  GPIO_WordWrite (GPIO1,0x0);
  GPIO_WordWrite (GPIO2,0x0);
  GPIO_WordWrite (GPIO3,0x0);
  GPIO_WordWrite (GPIO4,0x0);
  GPIO_WordWrite (GPIO5,0x0);
  GPIO_WordWrite (GPIO6,0x0);

  /*configure all GPIO as pushpull output */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT_PP;
  GPIO_InitStructure.GPIO_Pins = GPIO_PIN_ALL ;
  GPIO_Init (GPIO0, &GPIO_InitStructure);
  GPIO_Init (GPIO1, &GPIO_InitStructure);
  GPIO_Init (GPIO2, &GPIO_InitStructure);
  GPIO_Init (GPIO3, &GPIO_InitStructure);
  GPIO_Init (GPIO4, &GPIO_InitStructure);
  GPIO_Init (GPIO5, &GPIO_InitStructure);
  GPIO_Init (GPIO6, &GPIO_InitStructure);

  /* Pin P4.6 toggling before entering low power mode */
  while(counter)
  {
    GPIO_PinToggle();
    counter--;
  }

  /* enter in Low power mode */
  Enter_LPmode();

  /* set system clock to previous value*/
  Delay(0x2FFF);

  CMU_Init (&CMU_InitStructure);
  PRCCU_Init(&PRCCU_InitStructure);

  /* Pin P4.6 toggling after exit from low power modes */
  while(1)
  {
    GPIO_PinToggle();

  }/* while(1) */
} /* main */
/*******************************************************************************
* Function Name  : SLOW.
* Description    : Configures the MCLK. as CLK2 , CLK2/16, PLL off, CLK
* Input          : - CLK2
                   - CLK2_16
                   - FREE_PLL
                   - CLK
* Output         : None
* Return         : None
*******************************************************************************/
void SLOW(SlowClock_Typedef clock)
{
  PRCCU_InitTypeDef Clk2={ENABLE,PRCCU_MCLKSRC_CLOCK2};
  PRCCU_InitTypeDef Clk2_16={ENABLE,PRCCU_MCLKSRC_CLOCK2_16};
  PRCCU_InitTypeDef Free_Pll={ENABLE,PRCCU_MCLKSRC_PLL,0x7,PRCCU_PLLMUL_12,ENABLE};
  PRCCU_InitTypeDef Clk={DISABLE,PRCCU_MCLKSRC_CLOCK2};

  switch (clock)
  {
   /* select CLK2_16 as MCLK ,  PLL off */
  case CLK2_16: PRCCU_Init(&Clk2_16); 	break;
  /* select ClockConfig+FREE PLL enabled */
  case FREE_PLL: PRCCU_Init(&Free_Pll); break;
  /* select RC_32 and Quartz oscillator off */
  case CLK: PRCCU_Init(&Clk);		break;
  default:
    {
      /* select CLK2 as MCLK , PLL off */
      PRCCU_Init(&Clk2);
      break;
    }
  }
}
/*******************************************************************************
* Function Name  : Enter_LPmode
* Description    : Low power mode entering function
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Enter_LPmode (void)
{

  /*Slow Mode-------------------------------*/
#ifdef SLOW_Mode

  /* Configure the GPIO5.8 */
  GPIO_Configuration();

  /* switch on or switch off the MVR */
  PRCCU_VRCmd(PRCCU_VR_Run,DISABLE);

  /* switch off green LED */
  GPIO_BitWrite(GPIO4, GPIO_PIN_6,Bit_RESET);

  /* MCLK is CLK2/16, CLK2 or FREE_PLL */
  SLOW(CLK2_16);

  /* Test high active button on GPIO5.8 to continue */
  while (!GPIO_BitRead(GPIO5,GPIO_PIN_8));

  /* switch on the MVR */
  PRCCU_VRCmd(PRCCU_VR_Run,ENABLE);

#endif /* SLOW_Mode*/

  /*SLOW_RC_Mode-------------------------------*/
#ifdef SLOW_RC_Mode

  /* switch on green LED */
  GPIO_BitWrite(GPIO4, GPIO_PIN_6, Bit_SET);

  /* Configure the  GPIO5.8 */
  GPIO_Configuration();

  /* Test high active button on GPIO5.8 */
  while (!GPIO_BitRead(GPIO5,GPIO_PIN_8))
  {
    Delay(0xFF);
  }

  Delay(0xFFF);

  /* switch off green LED */
  GPIO_BitWrite(GPIO4, GPIO_PIN_6,Bit_RESET);

  /* switch off the MVR */
  PRCCU_VRCmd(PRCCU_VR_Run,DISABLE);

  /* configure the CMU */
  CMU_StructInit(&CMU_InitStructure);
  CMU_InitStructure.CMU_CKSEL0=CMU_CKSEL0_CKRC;
  CMU_Init (&CMU_InitStructure);
  CMU_Lock(DISABLE);
  CMU_ModeOscConfig(CMU_Run_Low);
  CMU_StopOscConfig(CMU_MainoscStop);
  CMU_Lock(ENABLE);

  /* MCLK is CLK2 with div 2 disabled */
  SLOW(CLK);

  Delay(0xFFF);

  /* Test high active button on GPIO5.8 to continue */
  while (!GPIO_BitRead(GPIO5,GPIO_PIN_8))
  {
    Delay(0xFF); 
  }

  /* switch on green LED */
  GPIO_BitWrite(GPIO4, GPIO_PIN_6,Bit_SET);

  /* switch on MVR */
  PRCCU_VRCmd(PRCCU_VR_Run,ENABLE);

#endif /* SLOW_RC_Mode */

  /* WFI_Mode----------------------------------*/
#ifdef WFI_Mode

  /*uncomment to use CLK2 or CLK2/16 instead of PLL clock*/
  /* SLOW(CLK2_16); */

  /* Uncomment to Enable the RTC */
  /* CFG_PeripheralClockConfig(CFG_CLK_RTC , ENABLE); */

  /* Configure the WIU and enable wake up on pin P6.6 */
  WIU_Configuration();

  /* Configure the EIC */
  EIC_Configuration();

  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);

  /* Enter in WFI mode */
  PRCCU_EnterLPM(PRCCU_LPM_WFI);

#endif /* WFI_Mode */

  /*LPWFI_Mode---------------------------------*/
  /* MCU in Low power WFI mode  CLK2_16, MVR stopped, Flash in power down */

#ifdef LPWFI_Mode

  /* Configure the WIU and enable wake up on pin P6.6*/
  WIU_Configuration();

  /* Configure the EIC */
  EIC_Configuration();

  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);
  /* MVR disabled */
  PRCCU_VRCmd(PRCCU_VR_LPWFI, DISABLE);

  /* Flash in power down when entering in LPWFI */
  FLASH_PowerDownConfig(ENABLE);

  /* Enter in LPWFI mode */
  PRCCU_EnterLPM(PRCCU_LPM_LPWFI);

#endif /*LPWFI_Mode */

  /* --------- LPWFI mode and RC clock is used in low speed (32kHz) ---------*/
#ifdef LPWFI_RC_Mode

  /* Configure the WIU and enable wake up on pin P6.6*/
  WIU_Configuration();

  /* Configure the EIC */
  EIC_Configuration();

  /* Configure the CMU */
  CMU_StructInit(&CMU_InitStructure);
  CMU_InitStructure.CMU_CKSEL0=CMU_CKSEL0_CKRC;
  CMU_Init (&CMU_InitStructure);
  CMU_Lock(DISABLE);
  CMU_ModeOscConfig(CMU_Run_High);
  CMU_StopOscConfig(CMU_MainoscStop);
  CMU_Lock(ENABLE);

  /* RC oscilllator Frequency adjust */
  CMU->RCCTL = 0x8;

  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);

  /* MVR disabled */
  PRCCU_VRCmd(PRCCU_VR_LPWFI, DISABLE);
  
  /* Flash in power down when entering in LPWFI */
    FLASH_PowerDownConfig(ENABLE);

  /* Enter in LPWFI mode */
  PRCCU_EnterLPM(PRCCU_LPM_LPWFI);

#endif /* LPWFI_RC_Mode */

  /* ---------------------------HALT_Mode-------------------------------------*/
#ifdef HALT_Mode

  /* Initialize button on GPIO5.8 */
  GPIO_Configuration();

  /* Test high active button on GPIO5.8 */
  while (!GPIO_BitRead(GPIO5,GPIO_PIN_8))
  {
    GPIO_BitWrite(GPIO4, GPIO_PIN_6,(BitAction)(~GPIO_BitRead(GPIO4, GPIO_PIN_6)));
    Delay (0xFFFF);
  }

  /* switch off green LED */
  GPIO_BitWrite(GPIO4, GPIO_PIN_6,Bit_RESET);

  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);

  /* Enter in HALT mode */
  PRCCU_EnterLPM(PRCCU_LPM_HALT);

#endif /* HALT_Mode */

  /* --------------------------STOP_Mode-------------------------------------*/
#ifdef STOP_Mode

  /* Configure the WIU and enable wake up on pin P6.6 */
  WIU_Configuration();

  /* Configure the EIC */
  EIC_Configuration();

  /* stop RC and main oscillators when stop mode occurs */
  CMU_Lock(DISABLE);
  CMU_StopOscConfig(CMU_RCoscHardStop);
  CMU_StopOscConfig(CMU_MainoscStop);
  CMU_Lock(ENABLE);

  /* Uncomment to Enable the RTC */
  /* CFG_PeripheralClockConfig(CFG_CLK_RTC , ENABLE); */

  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);

  /* MVR disabled */
  PRCCU_VRCmd(PRCCU_VR_LPWFI, DISABLE);

  /* Stop mode entering sequence*/
  do
  {
    WIU_EnterStopMode();
  }/* assure the Stop mode was really entered STOP_I = 1  STOP = 0 */
  while((PRCCU_FlagStatus(PRCCU_FLAG_STOP_I) == RESET)||((WIU->CTRL & WIU_STOP_Bit) == SET));


  /* at this stage the MCU entered and exited Stop mode ---------------------*/
  /* clear STOP_I flag */
  PRCCU_FlagClear(PRCCU_FLAG_STOP_I);

#endif /* STOP_Mode */


  /* ---------------------STOP mode and wake up made by WUT -----------------*/
#ifdef STOP_WUT_Mode

  /* RC oscillator frequency:= 29KHz in Stop mode */
  CMU_Lock(DISABLE);
  CMU_ModeOscConfig(CMU_Stop_High);
  CMU_StopOscConfig(CMU_MainoscStop);

  /* RC oscilaltor Frequency adjust */
  CMU->RCCTL = 0x0F;
 /* CMU->RCCTL = 0x00; */

  /* RTC Clock Enable */
  CFG_PeripheralClockConfig(CFG_CLK_RTC , ENABLE);

  /* WUT Clock Enable */
  CFG_PeripheralClockConfig (CFG_CLK_WUT, ENABLE);
  /* configure the WUT to wake-up the MCU from Stop mode in 10s */
  /* WUT End of Count event connected to WIU input line 0 */
  WUT_InitStructure.WUT_Mode = WUT_Mode_WakeUp;

  /* WUT clock 29KHz (when the MCU enter Stop mode) */
  WUT_InitStructure.WUT_CLK_Source = WUT_CLK_EXTERNAL;
  WUT_InitStructure.WUT_Prescaler = WUTPrescaler;
  WUT_InitStructure.WUT_Preload = WUTPreload;
  WUT_DeInit();
  WUT_Init(&WUT_InitStructure);

  /* Configure the WIU & select the WUT to wake-up the MCU from Stop mode */
  WIU_Configuration();

  /* start WUT */
  WUT_Cmd(ENABLE);

  /* added ***/
  /* 2,4 or 6 mA for the LPVR output current */
  PRCCU_LPVRCurrentConfig(PRCCU_LPVR_Current_2);

  /* Stop mode entering sequence */
  do
  {
    WIU_EnterStopMode();
  }/* assure the Stop mode was really entered STOP_I = 1  STOP = 0 */
  while((PRCCU_FlagStatus(PRCCU_FLAG_STOP_I) == RESET)||((WIU->CTRL & WIU_STOP_Bit) == SET));

  /* at this stage the MCU entered and exited Stop mode */
  /* clear STOP_I flag */
  PRCCU_FlagClear(PRCCU_FLAG_STOP_I);

  /* stop WUT */
  WUT_Cmd(DISABLE);

  /* clear WUT End of Count flag */
  WUT_FlagClear();

  /* clear wake-up line 0 flag */
  WIU_PendingBitClear(WIU_Line0);

#endif /* STOP_WUT_Mode */


  /* -------------------------RUN mode: RTC, TIM3, Flash ----------------------*/
#ifdef RUN_Mode
  /* Stop RC clock */
  CMU_StopOscConfig(CMU_RCoscSoftStop);

  /* Enable Peripheral as ADC, RTC and TIM3 */
  CFG_PeripheralClockConfig (CFG_CLK_RTC, ENABLE);
  CFG_PeripheralClockConfig (CFG_CLK_TIM3, ENABLE);

  /* Configure the EIC */
  EIC_Configuration();

  #ifdef ADC_ON
  CFG_PeripheralClockConfig (CFG_CLK_ADC, ENABLE);
 			
  /* Configures the ADC */
  ADC_Configuration();

  /* Start ADC conversion */
  ADC_ConversionCmd (ADC_ConversionStart);
  #endif /* ADC_ON */

  /* TIM3 Configuration in PULSE WIDTH MODULATION Mode*/
  TIM_DeInit(TIM3);

  TIM_InitStructure.TIM_Mode = TIM_PWM;
  TIM_InitStructure.TIM_Pulse_Level_A = TIM_High ;
  TIM_InitStructure.TIM_Clock_Source = TIM_CLK_INTERNAL;
  TIM_InitStructure.TIM_Period_Level = TIM_Low;
  TIM_InitStructure.TIM_Prescaler = 0x00;
  TIM_InitStructure.TIM_Pulse_Length_A = 0x3FFF;
  TIM_InitStructure.TIM_Full_Period = 0x7FFF;

  TIM_Init (TIM3, &TIM_InitStructure);
  TIM_ITConfig ( TIM3,TIM_IT_OCB ,ENABLE );

  TIM_CounterCmd(TIM3, TIM_START);

#endif /* RUN_MODE */

/*--------------------------------- RTC Mode --------------------------------*/
#ifdef RTC_Mode

  /* ----- GPIO Configuration -----*/
  /* GPIO4 Clock Enable */
  CFG_PeripheralClockConfig(CFG_CLK_GPIO4 , ENABLE);

  /* Configure GPIO4  */
  GPIO_Configuration();

  /* ----- EIC Configuration -----*/
  /* Enable EIC Clock  */
  CFG_PeripheralClockConfig(CFG_CLK_EIC , ENABLE);

  /* Configure the EIC */
  EIC_Configuration();

  /* ------- RTC Configuration ------*/
  /* RTC Clock Enable */
  CFG_PeripheralClockConfig(CFG_CLK_RTC , ENABLE);

  /* RTC Initialization------------------------------- */
  RTC_DeInit();
  RTC_StructInit(&RTC_InitStructure);

  /* Set RTC clock-------------------------------------- */
  /* (clock:0-->9) CKOSC=8Mhz/RTP=(2,4,8,16,32,64,128,256,512,1024)
  -->RCK=(4M,2M,1M,500K,250K,125K,62.5K,31.25K,15.625K,7.812K) */
  PRCCU_SetExtClkDiv(8);

  /* RTC Interrupt Config----------------------------- */
  RTC_ITConfig (RTC_IT_SEC | RTC_IT_ALA | RTC_IT_OV, ENABLE);
  /* Alarm Init */
  RTC_InitStructure.RTC_Alarm = 0xFFFFFFFF;
  /* Counter Init */
  RTC_InitStructure.RTC_Counter = 0xFFFFFFFA;
  /* 1 second Prescaler Init */
  RTC_InitStructure.RTC_Prescaler = 0x7A12; /* configure RTC =1S  */
  /* Configure the RTC */
  RTC_Init (&RTC_InitStructure);

  while (!GPIO_BitRead(GPIO5,GPIO_PIN_8)); /*test low active button on GPIO5.8 */

#endif /* RTC_Mode */

  /*--------------------RUN mode with all peripherals Enabled ----------------*/
#ifdef RUN_ALLON_Mode

  /* Enable all peripherals */
  CFG_PeripheralClockConfig(CFG_CLK_RAM , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_I2C0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_WIU , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM3 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM4 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM5 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO3 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO4 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO5 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO6 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_ADC , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_EIC , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_WUT , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_I2C1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM5 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM6 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM7 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM8 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM9 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART3 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM3 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM4 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_RTC , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA0 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA1 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA2 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA3 , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_ARB , ENABLE);
  CFG_PeripheralClockConfig(CFG_CLK_AHB , ENABLE);


  /*CFG_PeripheralClockConfig(CFG_CLK_RAM , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_I2C0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_WIU , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM3 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM4 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_PWM5 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO3 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO4 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO5 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_GPIO6 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_BSPI2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_ADC , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_EIC , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_WUT , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_I2C1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM5 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM6 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM7 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM8 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM9 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_UART3 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TB2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_CAN2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM3 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_TIM4 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_RTC , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA0 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA1 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA2 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_DMA3 , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_ARB , DISABLE);
  CFG_PeripheralClockConfig(CFG_CLK_AHB , DISABLE); */

 
  CFG_PeripheralClockConfig (CFG_CLK_ADC, ENABLE);

  /* Configures the ADC */
  ADC_Configuration();

  /* Start ADC conversion */
  ADC_ConversionCmd (ADC_ConversionStart);
  do{
    while (ADC_FlagStatus(ADC_FLAG_EOC))
    {
      ADC_GetConversionValue( ADC_CHANNEL0);
      ADC_FlagClear (ADC_FLAG_EOC);
    }
  }while(1);

#endif /* RUN_ALLON_Mode */

}/* Enter_LPmode */
/*******************************************************************************
* Function Name  : WIU_Configuration
* Description    : Configure the WIU
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void WIU_Configuration (void)
{
#if (defined(WFI_Mode)||defined(LPWFI_Mode) ||defined(LPWFI_RC_Mode)|| defined(STOP_Mode))

  /* Wake up pin configuration */
  /* Configure  the GPIO6 pin P6.6 */
  GPIO_InitStructure.GPIO_Pins=GPIO_PIN_6;
  GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IN_TRI_TTL;
  GPIO_Init(GPIO6,&GPIO_InitStructure);

  /* Initialize the wake up system */
  WIU_InitStructure.WIU_Mode = WIU_Mode_WakeUpInterrupt;
  WIU_InitStructure.WIU_TriggerEdge = WIU_RisingEdge;
  WIU_InitStructure.WIU_Line = WIU_Line6;
  WIU_DeInit();
  WIU_Init(&WIU_InitStructure);

#endif

#ifdef STOP_WUT_Mode

  /* Select the WUT to wake-up the MCU from Stop mode */
  WIU_InitStructure.WIU_Mode = WIU_Mode_WakeUp;
  WIU_InitStructure.WIU_TriggerEdge = WIU_FallingEdge;
  WIU_InitStructure.WIU_Line = WIU_Line0;
  WIU_DeInit();
  WIU_Init(&WIU_InitStructure);

#endif /* STOP_WUT_Mode */
}
/*******************************************************************************
* Function Name  : EIC_Configuration
* Description    : Configure the EIC
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EIC_Configuration(void)
{
#if (defined(WFI_Mode) ||defined(LPWFI_Mode)|| defined(LPWFI_RC_Mode)|| \
  defined(STOP_Mode)|| defined(RTC_Mode))

  EIC_IRQChannelPriorityConfig(WIU_IRQChannel,1);
  EIC_IRQChannelConfig(WIU_IRQChannel,ENABLE);
  EIC_IRQCmd(ENABLE);

#endif

#ifdef RUN_Mode

  EIC_IRQChannelPriorityConfig( ADC_IRQChannel, 1);
  EIC_IRQChannelConfig( ADC_IRQChannel , ENABLE );
  EIC_IRQChannelPriorityConfig( RTC_IRQChannel, 2);
  EIC_IRQChannelConfig( RTC_IRQChannel , ENABLE );
  EIC_IRQChannelConfig(TIM3_IRQChannel, ENABLE );
  EIC_IRQChannelPriorityConfig(TIM3_IRQChannel,3);
  EIC_IRQCmd(ENABLE);

#endif /* RUN_Mode */
}
/*******************************************************************************
* Function Name  : ADC_Configuration
* Description    : Configure the ADC
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void ADC_Configuration(void)
{
#if (defined(RUN_ALLON_Mode) || defined(ADC_ON))

  ADC_DeInit ();
  ADC_StructInit(&ADC_InitStructure);
  ADC_InitStructure.ADC_Calibration = ADC_Calibration_ON;
  ADC_InitStructure.ADC_CalibAverage = ADC_CalibAverage_Enable;
  ADC_InitStructure.ADC_AutoClockOff = ADC_AutoClockOff_Disable ;
  ADC_InitStructure.ADC_ConversionMode = ADC_ConversionMode_Scan ;
  ADC_InitStructure.ADC_SamplingPrescaler = 0x0;
  ADC_InitStructure.ADC_ConversionPrescaler = 0x1;
  ADC_InitStructure.ADC_FirstChannel = ADC_CHANNEL0 ;
  ADC_InitStructure.ADC_ChannelNumber = 1;
  ADC_Init (&ADC_InitStructure);
  ADC_Cmd(ENABLE);

#endif

}
/*******************************************************************************
* Function Name  : GPIO_PinToggle
* Description    : Toggle the P4.6 pin
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_PinToggle(void)
{
  GPIO_BitWrite (GPIO4, GPIO_PIN_6, Bit_SET);
  Delay(0x2FFFF);

  GPIO_BitWrite (GPIO4, GPIO_PIN_6, Bit_RESET);
  Delay(0x2FFFF);

}
/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configure the GPIO
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
#if (defined(SLOW_Mode) || defined(SLOW_RC_Mode) || defined(HALT_Mode))

  /* Initialize button on GPIO5.8 */
  GPIO_InitStructure.GPIO_Pins=GPIO_PIN_8;
  GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IN_TRI_TTL;
  GPIO_Init(GPIO5, &GPIO_InitStructure);

#endif


#ifdef RTC_Mode

  /* GPIO4 Configuration */
  GPIO_DeInit (GPIO4);
  GPIO_StructInit(&GPIO_InitStructure);
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT_PP;
  GPIO_InitStructure.GPIO_Pins = GPIO_PIN_6 ;
  GPIO_Init (GPIO4, &GPIO_InitStructure);

  /* Initialize button on GPIO5.8 */
  GPIO_InitStructure.GPIO_Pins=GPIO_PIN_8;
  GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IN_TRI_TTL;
  GPIO_Init(GPIO5, &GPIO_InitStructure);

#endif /* RTC_Mode */

}
/*******************************************************************************
* Function Name  : Delay
* Description    : Delay function
* Input          : Delay value
* Output         : None
* Return         : None
*******************************************************************************/
void Delay(u32 Xtime)
{
  u32 j;

  for(j=Xtime;j!=0;j--);
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
